/***********************************************************
* Written by Robert Green                                  *
* Parallel port example and control program                *
* Freely distributable just give appropiate credit         *
* To compile:                                              *
*    gcc -O2 haunt_linux.c -o haunt_linux                  *
************************************************************/

#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<asm/io.h>

#define BASEPORT 0x378

#define LINE1 0x08
#define LINE2 0x10
#define LINE3 0x20
#define LINE4 0x40
#define LINE5 0x80

int main()
   {
   unsigned short int read_val; 


   if(ioperm(BASEPORT, 3, 1)) {
      perror("ioperm");
      return 1;
      }

   outb(0x00, BASEPORT);

   while(1) {

      read_val = inb(BASEPORT+1);

      if( (read_val & LINE1) && (read_val & LINE2) ) {
         outb(0x01, BASEPORT);
         sleep(10); /* how long do you want fog */
         outb(0x00, BASEPORT);
         }
      
      sleep(1);
      }

   if( ioperm(BASEPORT, 3, 0)) {
      perror("ioperm");
      return 1;
      }

   return 0;
   }
